--NIGHTSTORM A2G Training Missiles

local function calcPiercingMass(warhead)
	warhead.piercing_mass  = warhead.mass;
	if (warhead.expl_mass/warhead.mass > 0.1) then
		warhead.piercing_mass  = warhead.mass/5.0;
	end
end

function HE_penetrating_warhead(power,caliber)
	local res = {};
	
	res.caliber = caliber;
    res.expl_mass = power;
	res.mass = res.expl_mass;
    res.other_factors = { 0.5, 0.5, 0.5 };
    res.obj_factors = {1, 1};
    res.concrete_factors = {1, 1, 1};
    res.concrete_obj_factor = 2.0;
	res.cumulative_factor = 0.0;    
    res.cumulative_thickness = 0.0;
    
    calcPiercingMass(res)
	return res;
end

[[		--NIGHTSTORM For some unknown reason these act like they weigh too much for an aircraft to carry.  I don't see the problem but they will not work correctly.
*******************************************CATM-88**************************************************

local CATM_88 = { 

	category		= CAT_MISSILES,
	name			= _("CATM_88"),
	user_name		= _("CATM-88"),
	wsTypeOfWeapon	= {wsType_Weapon,wsType_Missile,wsType_AS_Missile,WSTYPE_PLACEHOLDER},
	NatoName		= "(CATM-88)",

	shape_table_data =
	{
		{
			name = "CATM_88";
			file = "CATM_88";
			life = 1;
			fire = { 0, 1};
			username = "CATM_88";
			index = WSTYPE_PLACEHOLDER,
		},
	},

        Escort = 0,
        Head_Type = 5,
		sigma = {10, 10, 10},
        M = 361.0,
        H_max = 24400.0,
        H_min = -1,
        Diam = 254.0,
        Cx_pil = 4,
        D_max = 151000.0,
        D_min = 3500.0,
        Head_Form = 1,
        Life_Time = 400,
        Nr_max = 12,
        v_min = 170.0,
        v_mid = 400.0,
        Mach_max = 3.2,
        t_b = 0.0,
        t_acc = 5.0,
        t_marsh = 10.0,
        Range_max = 134000.0,
        H_min_t = 0.0,
        Fi_start = 0.35,
        Fi_rak = 3.14152,
        Fi_excort = 1.0,
        Fi_search = 99.9,
        OmViz_max = 99.9,
        warhead = simple_warhead(0.0001); -- inert warhead for training munition
        exhaust = {0.9, 0.9, 0.9, 0.2};
        X_back = -1.506,
        Y_back = -0.126,
        Z_back = 0.0,
        Reflection = 0.05,
        KillDistance = 0.0,

}

declare_weapon(CATM_88)


declare_loadout(
	{		
		category		= CAT_MISSILES, 
		CLSID			= "{CATM-88}",
		attribute		= {wsType_Weapon, wsType_Missile, wsType_Container, WSTYPE_PLACEHOLDER},
		wsTypeOfWeapon	= CATM_88.wsTypeOfWeapon,
		Count			= 1,
		Picture			= "agm88.png",
		displayName		= _("CATM-88 HARM - Training Missile"),
		Weight			= 361,
		Cx_pil			= 4,

		Elements	=	
				{
					[1]	=	
					{
						Position	=	{0,	0,	0},
						ShapeName	=	"lau-118a",
					}, 
					[2]	=	
					{
						DrawArgs	=	
						{
							[1]	=	{1,	1},
							[2]	=	{2,	1},
						}, -- end of DrawArgs
						Position	=	{0.05,	-0.13,	0},
						ShapeName	=	"CATM_88",
					}, 
				}, -- end of Elements		
				Required	=	{"{8C3F26A2-FA0F-11d5-9190-00A0249B6F00}",},		
	}
)
]]

--*******************************************TGM-65D************************************************

local TGM_65D = { 

	category		= CAT_MISSILES,
	name			= _("TGM_65D"),
	user_name		= _("TGM-65D"),
	wsTypeOfWeapon	= {wsType_Weapon,wsType_Missile,wsType_AS_Missile,WSTYPE_PLACEHOLDER},
	NatoName		= "(TGM-65D)",

	shape_table_data =
	{
		{
			name = "tgm-65d";
			file = "tgm-65d";
			life = 1;
			fire = { 0, 1};
			username = "tgm-65d";
			index = WSTYPE_PLACEHOLDER,
		},
	},

        Escort = 0,
        Head_Type = 5,
		sigma = {5, 5, 5},
        M = 301.0,
        H_max = 10000.0,
        H_min = -1,
        Diam = 305.0,
        Cx_pil = 4,
        D_max = 12964.0,
        D_min = 500.0,
        Head_Form = 0,
        Life_Time = 110,
        Nr_max = 16,
        v_min = 50.0,
        v_mid = 290.0,
        Mach_max = 1.5,
        t_b = 0.0,
        t_acc = 4.0,
        t_marsh = 0.0,
        Range_max = 24076.0,
        H_min_t = 0.0,
        Fi_start = 0.5,
        Fi_rak = 3.14152,
        Fi_excort = 1.05,
        Fi_search = 99.9,
        OmViz_max = 99.9,
        warhead = warheads["TGM_65G"],
        exhaust = tail_solid,
        X_back = -0.879,
        Y_back = -0.155,
        Z_back = 0.0,
        Reflection = 0.063,
        KillDistance = 0.0,

}

declare_weapon(TGM_65D)

declare_loadout(
	{		
		category		= CAT_MISSILES,
		CLSID			= "{TGM-65D}",
		attribute		= {wsType_Weapon, wsType_Missile, wsType_Container, WSTYPE_PLACEHOLDER},
		wsTypeOfWeapon	= TGM_65D.wsTypeOfWeapon,
		Count			= 1,
		Picture			= "CATM65K.png",
		displayName		= _("TGM-65D Maverick - Training Missile"),
		Weight			= 301,
		Cx_pil			= 4,
		Elements		={
			[1] =
			{
				DrawArgs	=	
				{
					[1]	=	{1,	1},
					[2]	=	{2,	1},
				}, -- end of DrawArgs
				Position	=	{0,	0,	0},
				ShapeName	=	"tgm-65d",
			},
		},
	}
)

--*******************************************TGM-65E************************************************
local TGM_65E = { 

	category		= CAT_MISSILES,
	name			= _("TGM_65E"),
	user_name		= _("TGM-65E"),
	wsTypeOfWeapon	= {wsType_Weapon,wsType_Missile,wsType_AS_Missile,WSTYPE_PLACEHOLDER},
	NatoName		= "(TGM-65E)",

	shape_table_data =
	{
		{
			name = "tgm-65e";
			file = "tgm-65e";
			life = 1;
			fire = { 0, 1};
			username = "tgm-65e";
			index = WSTYPE_PLACEHOLDER,
		},
	},

        Escort = 0,
        Head_Type = 5,
		sigma = {5, 5, 5},
        M = 301.0,
        H_max = 10000.0,
        H_min = -1,
        Diam = 305.0,
        Cx_pil = 4,
        D_max = 12964.0,
        D_min = 500.0,
        Head_Form = 0,
        Life_Time = 110,
        Nr_max = 16,
        v_min = 50.0,
        v_mid = 290.0,
        Mach_max = 1.5,
        t_b = 0.0,
        t_acc = 4.0,
        t_marsh = 0.0,
        Range_max = 24076.0,
        H_min_t = 0.0,
        Fi_start = 0.5,
        Fi_rak = 3.14152,
        Fi_excort = 1.05,
        Fi_search = 99.9,
        OmViz_max = 99.9,
        warhead = warheads["TGM_65G"],
        exhaust = tail_solid,
        X_back = -0.879,
        Y_back = -0.155,
        Z_back = 0.0,
        Reflection = 0.063,
        KillDistance = 0.0,

}

declare_weapon(TGM_65E)

declare_loadout(
	{		
		category		= CAT_MISSILES,
		CLSID			= "{TGM-65E}",
		attribute		= {wsType_Weapon, wsType_Missile, wsType_Container, WSTYPE_PLACEHOLDER},
		wsTypeOfWeapon	= TGM_65E.wsTypeOfWeapon,
		Count			= 1,
		Picture			= "CATM65K.png",
		displayName		= _("TGM-65E Maverick - Training Missile"),
		Weight			= 301,
		Cx_pil			= 4,
		Elements		={
			[1] =
			{
				DrawArgs	=	
				{
					[1]	=	{1,	1},
					[2]	=	{2,	1},
				}, -- end of DrawArgs
				Position	=	{0,	0,	0},
				ShapeName	=	"tgm-65e",
			},
		},
	}
)

--*******************************************TGM-65F************************************************

local TGM_65F = { 

	category		= CAT_MISSILES,
	name			= _("TGM_65F"),
	user_name		= _("TGM-65F"),
	wsTypeOfWeapon	= {wsType_Weapon,wsType_Missile,wsType_AS_Missile,WSTYPE_PLACEHOLDER},
	NatoName		= "(TGM-65F)",

	shape_table_data =
	{
		{
			name = "tgm-65f";
			file = "tgm-65f";
			life = 1;
			fire = { 0, 1};
			username = "tgm-65f";
			index = WSTYPE_PLACEHOLDER,
		},
	},

        Escort = 0,
        Head_Type = 5,
		sigma = {5, 5, 5},
        M = 301.0,
        H_max = 10000.0,
        H_min = -1,
        Diam = 305.0,
        Cx_pil = 4,
        D_max = 12964.0,
        D_min = 500.0,
        Head_Form = 0,
        Life_Time = 110,
        Nr_max = 16,
        v_min = 50.0,
        v_mid = 290.0,
        Mach_max = 1.5,
        t_b = 0.0,
        t_acc = 4.0,
        t_marsh = 0.0,
        Range_max = 24076.0,
        H_min_t = 0.0,
        Fi_start = 0.5,
        Fi_rak = 3.14152,
        Fi_excort = 1.05,
        Fi_search = 99.9,
        OmViz_max = 99.9,
        warhead = warheads["TGM_65G"],
        exhaust = tail_solid,
        X_back = -0.879,
        Y_back = -0.155,
        Z_back = 0.0,
        Reflection = 0.063,
        KillDistance = 0.0,

}

declare_weapon(TGM_65F)

declare_loadout(
	{		
		category		= CAT_MISSILES,
		CLSID			= "{TGM-65F}",
		attribute		= {wsType_Weapon, wsType_Missile, wsType_Container, WSTYPE_PLACEHOLDER},
		wsTypeOfWeapon	= TGM_65F.wsTypeOfWeapon,
		Count			= 1,
		Picture			= "CATM65K.png",
		displayName		= _("TGM-65F Maverick - Training Missile"),
		Weight			= 301,
		Cx_pil			= 4,
		Elements		={
			[1] =
			{
				DrawArgs	=	
				{
					[1]	=	{1,	1},
					[2]	=	{2,	1},
				}, -- end of DrawArgs
				Position	=	{0,	0,	0},
				ShapeName	=	"tgm-65f",
			},
		},
	}
)
--*******************************************TGM-65G************************************************

local TGM_65G = { 

	category		= CAT_MISSILES,
	name			= _("TGM_65G"),
	user_name		= _("TGM-65G"),
	wsTypeOfWeapon	= {wsType_Weapon,wsType_Missile,wsType_AS_Missile,WSTYPE_PLACEHOLDER},
	NatoName		= "(TGM-65G)",

	shape_table_data =
	{
		{
			name = "tgm-65g";
			file = "tgm-65g";
			life = 1;
			fire = { 0, 1};
			username = "tgm-65g";
			index = WSTYPE_PLACEHOLDER,
		},
	},

        Escort = 0,
        Head_Type = 5,
		sigma = {5, 5, 5},
        M = 301.0,
        H_max = 10000.0,
        H_min = -1,
        Diam = 305.0,
        Cx_pil = 4,
        D_max = 12964.0,
        D_min = 500.0,
        Head_Form = 0,
        Life_Time = 110,
        Nr_max = 16,
        v_min = 50.0,
        v_mid = 290.0,
        Mach_max = 1.5,
        t_b = 0.0,
        t_acc = 4.0,
        t_marsh = 0.0,
        Range_max = 24076.0,
        H_min_t = 0.0,
        Fi_start = 0.5,
        Fi_rak = 3.14152,
        Fi_excort = 1.05,
        Fi_search = 99.9,
        OmViz_max = 99.9,
        warhead = warheads["TGM_65G"],
        exhaust = tail_solid,
        X_back = -0.879,
        Y_back = -0.155,
        Z_back = 0.0,
        Reflection = 0.063,
        KillDistance = 0.0,

}

declare_weapon(TGM_65G)

declare_loadout(
	{		
		category		= CAT_MISSILES,
		CLSID			= "{TGM-65G}",
		attribute		= {wsType_Weapon, wsType_Missile, wsType_Container, WSTYPE_PLACEHOLDER},
		wsTypeOfWeapon	= TGM_65G.wsTypeOfWeapon,
		Count			= 1,
		Picture			= "CATM65K.png",
		displayName		= _("TGM-65G Maverick - Training Missile"),
		Weight			= 301,
		Cx_pil			= 4,
		Elements		={
			[1] =
			{
				DrawArgs	=	
				{
					[1]	=	{1,	1},
					[2]	=	{2,	1},
				}, -- end of DrawArgs
				Position	=	{0,	0,	0},
				ShapeName	=	"tgm-65g",
			},
		},
	}
)
--*******************************************TGM-65H************************************************

local TGM_65H = { 

	category		= CAT_MISSILES,
	name			= _("TGM_65H"),
	user_name		= _("TGM-65H"),
	wsTypeOfWeapon	= {wsType_Weapon,wsType_Missile,wsType_AS_Missile,WSTYPE_PLACEHOLDER},
	NatoName		= "(TGM-65D)",

	shape_table_data =
	{
		{
			name = "tgm-65h";
			file = "tgm-65h";
			life = 1;
			fire = { 0, 1};
			username = "tgm-65h";
			index = WSTYPE_PLACEHOLDER,
		},
	},

        Escort = 0,
        Head_Type = 5,
		sigma = {5, 5, 5},
        M = 301.0,
        H_max = 10000.0,
        H_min = -1,
        Diam = 305.0,
        Cx_pil = 4,
        D_max = 12964.0,
        D_min = 500.0,
        Head_Form = 0,
        Life_Time = 110,
        Nr_max = 16,
        v_min = 50.0,
        v_mid = 290.0,
        Mach_max = 1.5,
        t_b = 0.0,
        t_acc = 4.0,
        t_marsh = 0.0,
        Range_max = 24076.0,
        H_min_t = 0.0,
        Fi_start = 0.5,
        Fi_rak = 3.14152,
        Fi_excort = 1.05,
        Fi_search = 99.9,
        OmViz_max = 99.9,
        warhead = warheads["TGM_65G"],
        exhaust = tail_solid,
        X_back = -0.879,
        Y_back = -0.155,
        Z_back = 0.0,
        Reflection = 0.063,
        KillDistance = 0.0,

}

declare_weapon(TGM_65H)

declare_loadout(
	{		
		category		= CAT_MISSILES,
		CLSID			= "{TGM-65H}",
		attribute		= {wsType_Weapon, wsType_Missile, wsType_Container, WSTYPE_PLACEHOLDER},
		wsTypeOfWeapon	= TGM_65H.wsTypeOfWeapon,
		Count			= 1,
		Picture			= "CATM65K.png",
		displayName		= _("TGM-65H Maverick - Training Missile"),
		Weight			= 301,
		Cx_pil			= 4,
		Elements		={
			[1] =
			{
				DrawArgs	=	
				{
					[1]	=	{1,	1},
					[2]	=	{2,	1},
				}, -- end of DrawArgs
				Position	=	{0,	0,	0},
				ShapeName	=	"tgm-65h",
			},
		},
	}
)
--*******************************************CATM-65K************************************************
local CATM_65K = { 

	category		= CAT_MISSILES,
	name			= _("CATM_65K"),
	user_name		= _("CATM-65K"),
	wsTypeOfWeapon	= {wsType_Weapon,wsType_Missile,wsType_AS_Missile,WSTYPE_PLACEHOLDER},
	NatoName		= "(CATM-65K)",

	shape_table_data =
	{
		{
			name = "catm-65k";
			file = "catm-65k";
			life = 1;
			fire = { 0, 1};
			username = "catm-65k";
			index = WSTYPE_PLACEHOLDER,
		},
	},

        Escort = 0,
        Head_Type = 5,
		sigma = {5, 5, 5},
        M = 301.0,
        H_max = 10000.0,
        H_min = -1,
        Diam = 305.0,
        Cx_pil = 4,
        D_max = 12964.0,
        D_min = 500.0,
        Head_Form = 0,
        Life_Time = 110,
        Nr_max = 16,
        v_min = 50.0,
        v_mid = 290.0,
        Mach_max = 1.5,
        t_b = 0.0,
        t_acc = 4.0,
        t_marsh = 0.0,
        Range_max = 24076.0,
        H_min_t = 0.0,
        Fi_start = 0.5,
        Fi_rak = 3.14152,
        Fi_excort = 1.05,
        Fi_search = 99.9,
        OmViz_max = 99.9,
        warhead = warheads["TGM_65G"],
        exhaust = tail_solid,
        X_back = -0.879,
        Y_back = -0.155,
        Z_back = 0.0,
        Reflection = 0.063,
        KillDistance = 0.0,

}

declare_weapon(CATM_65K)

declare_loadout(
	{		
		category		= CAT_MISSILES,
		CLSID			= "{CATM-65K}",
		attribute		= {wsType_Weapon, wsType_Missile, wsType_Container, WSTYPE_PLACEHOLDER},
		wsTypeOfWeapon	= CATM_65K.wsTypeOfWeapon,
		Count			= 1,
		Picture			= "CATM65K.png",
		displayName		= _("CATM-65K Maverick - Training Missile"),
		Weight			= 301,
		Cx_pil			= 4,
		Elements		={
			[1] =
			{
				DrawArgs	=	
				{
					[1]	=	{1,	1},
					[2]	=	{2,	1},
				}, -- end of DrawArgs
				Position	=	{0,	0,	0},
				ShapeName	=	"catm-65k", 
			},
		},
	}
)


--*******************************************Variants and Pylons************************************************

local agm65_variants =
{
	["TGM-65D"]  		= {display_name = _("TGM-65D Maverick - Training Missile"), Picture	=	"CATM65K.png", ws_type = TGM_65D.wsTypeOfWeapon,	category = CAT_MISSILES, mass = 301.0},
	["TGM-65E"]  		= {display_name = _("TGM-65E Maverick - Training Missile"), Picture	=	"CATM65K.png", ws_type = TGM_65E.wsTypeOfWeapon,	category = CAT_MISSILES, mass = 301.0},
	["TGM-65F"]  		= {display_name = _("TGM-65F Maverick - Training Missile"), Picture	=	"CATM65K.png", ws_type = TGM_65F.wsTypeOfWeapon,	category = CAT_MISSILES, mass = 301.0},	
	["TGM-65G"]  		= {display_name = _("TGM-65G Maverick - Training Missile"), Picture	=	"CATM65K.png", ws_type = TGM_65G.wsTypeOfWeapon,	category = CAT_MISSILES, mass = 301.0},
	["TGM-65H"]  		= {display_name = _("TGM-65H Maverick - Training Missile"), Picture	=	"CATM65K.png", ws_type = TGM_65H.wsTypeOfWeapon,	category = CAT_MISSILES, mass = 301.0},
	["CATM-65K"]  		= {display_name = _("CATM-65K Maverick - Training Missile"), Picture	=	"CATM65K.png", ws_type = CATM_65K.wsTypeOfWeapon,	category = CAT_MISSILES, mass = 297.0},	
}

--*******************************************LAU-117************************************************

local function lau_117_Maverick(clsid,element)

	local var 	   = agm65_variants[element] or agm65_variants["TGM-65D"]
	local var_mass = var.mass or 301.0
	local display_name	= var.display_name or element
	
	local ret = {
		category			=	CAT_MISSILES,
		CLSID				=	clsid,
		Picture				=	var.Picture,
		wsTypeOfWeapon		=	var.ws_type,
		attribute     		=  {4,	4,	32,	WSTYPE_PLACEHOLDER},
		Count 			  	= 1,
		displayName	  		=	_("LAU-117 with").." "..display_name,
		Weight  		  	= LAU_117_mass + var.mass,
		Cx_pil				= 0.00025 + 0.0009765625,
		Cx_item				= 0.0009765625,
		Elements		  = 
		{
			{
				Position	=	{0,	0,	0},
				ShapeName	=	"LAU-117",
			}, 
			{
				DrawArgs	=	
				{
					[1]	=	{1,	1},
					[2]	=	{2,	1},
				}, -- end of DrawArgs
				Position	=	{0.18,	-0.078,	0},
				ShapeName	=	"TGM-65d",
			}
		}
	}

	declare_loadout(ret)
end

lau_117_Maverick("LAU_117_TGM_65D"	,"TGM-65D")
lau_117_Maverick("LAU_117_TGM_65E"	,"TGM-65E")
lau_117_Maverick("LAU_117_TGM_65F"	,"TGM-65F")
lau_117_Maverick("LAU_117_TGM_65G"	,"TGM-65G")
lau_117_Maverick("LAU_117_TGM_65H"	,"TGM-65H")
lau_117_Maverick("LAU_117_CATM_65K"	,"CATM-65K")







